-- Tabele z pliku GrafikUczelniStrukturaZmianaPG.sql muszą zostać utworzone najpierw.

SET search_path TO GrafikUczelniZmiana;

CREATE FUNCTION R15_skoryguj_numery_kierunkowe_pracownikow() RETURNS void AS $$
UPDATE Pracownicy
SET NumKierPracownika = '360'
WHERE (KodPocztowyPracownika IN ('98270', '98271'));
$$ LANGUAGE SQL;

CREATE VIEW R15_skoryguj_numery_kierunkowe_pracownikow_zapytanie
AS 
SELECT  NumKierPracownika, '360' As NowyNumerKierunkowy
FROM    Pracownicy
WHERE   (KodPocztowyPracownika IN ('98270', '98271'));


CREATE FUNCTION R15_skoryguj_numer_kierunkowy_studenta() RETURNS void AS $$
UPDATE Studenci
SET NumKierStudenta = '360'
WHERE (KodPocztowyStudenta IN ('98270', '98271'));
$$ LANGUAGE SQL;

CREATE VIEW R15_skoryguj_numer_kierunkowy_studenta_zapytanie
AS 
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, NumKierStudenta, '360' AS NowyNumerKierunkowy
FROM    Studenci
WHERE   (KodPocztowyStudenta IN ('98270', '98271'));


CREATE FUNCTION R15_podwyzki_dla_pelnoetatowych_wykladowcow() RETURNS void AS $$
UPDATE Pracownicy
SET Wynagrodzenie = ROUND(Wynagrodzenie * 1.05, 0)
WHERE (IDPracownika IN
          (SELECT IDPracownika
           FROM Wykladowcy
           WHERE Wykladowcy.Status = 'Pełny wymiar' AND Wykladowcy.Etat = 1));
$$ LANGUAGE SQL;

CREATE VIEW R15_podwyzki_dla_pelnoetatowych_wykladowcow_zapytanie
AS 
SELECT Wynagrodzenie, ROUND(Wynagrodzenie * 1.05, 0) AS NoweWynagrodzenie
FROM Pracownicy
WHERE (IDPracownika IN
          (SELECT IDPracownika
           FROM Wykladowcy
           WHERE Wykladowcy.Status = 'Pełny wymiar' AND Wykladowcy.Etat = 1));


CREATE FUNCTION R15_zaktualizuj_srednia_ocen() RETURNS void AS $$
UPDATE Studenci
SET SredniaOcenStudenta =
         COALESCE((SELECT Round(SUM(Zajecia.PunktyEdukacyjne * 
                      CAST(Grafik_studenta.Ocena AS decimal(15,4))) / 
                       SUM(Zajecia.PunktyEdukacyjne), 3)
                 FROM Zajecia INNER JOIN Grafik_studenta 
                   ON Zajecia.IDZajec = Grafik_studenta.IDZajec
                 WHERE (Grafik_studenta.StatusZajec = 2) AND 
                      (Grafik_studenta.IDStudenta = Studenci.IDStudenta)), 0);
$$ LANGUAGE SQL;

CREATE VIEW R15_zaktualizuj_srednia_ocen_zapytanie
AS 
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, SredniaOcenStudenta, 
         COALESCE((SELECT Round(SUM(Zajecia.PunktyEdukacyjne * 
                      CAST(Grafik_studenta.Ocena AS decimal(15,4))) / 
                       SUM(Zajecia.PunktyEdukacyjne), 3)
                 FROM Zajecia INNER JOIN Grafik_studenta 
                   ON Zajecia.IDZajec = Grafik_studenta.IDZajec
                 WHERE (Grafik_studenta.StatusZajec = 2) AND 
                      (Grafik_studenta.IDStudenta = Studenci.IDStudenta)), 0) AS NewSredniaOcenStudenta
FROM Studenci;


CREATE FUNCTION R16_dodaj_dziedzine() RETURNS void AS $$
INSERT INTO Dziedziny
SELECT 'ITA' AS IDDziedziny, 'Włoski' AS OpisDziedziny, IDWydzialu
FROM Wydzialy
WHERE (NazwaWydzialu = 'Nauki humanistyczne');
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_dziedzine_zapytanie
AS 
SELECT 'ITA' AS IDDziedziny, 'Włoski' AS OpisDziedziny, IDWydzialu
FROM Wydzialy
WHERE (NazwaWydzialu = 'Nauki humanistyczne');


CREATE FUNCTION R16_dodaj_nowe_zajecia_z_ksiegowosci() RETURNS void AS $$
INSERT INTO Zajecia (IDPrzedmiotu, IDSali, PunktyEdukacyjne, 
      DataRozpoczecia, GodzinaRozpoczecia, CzasTrwania, PlanNaWtorek, PlanNaCzwartek)
VALUES (4, 3315, 5, '2018-01-16', '15:00:00', 80, 1, 1);
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_nowe_zajecia_z_ksiegowosci_zapytanie
AS
SELECT 4 As IDPrzedmiotu, 3315 As IDSali, 5 As PunktyEdukacyjne, '2018-01-16' As DataRozpoczecia, 
   '15:00:00' As GodzinaRozpoczecia, 80 As CzasTrwania, -1 As PlanNaWtorek, -1 As PlanNaCzwartek
FROM Zajecia
WHERE IDZajec = 1000;


CREATE FUNCTION R16_dodaj_studenta() RETURNS void AS $$
INSERT INTO Studenci (ImieStudenta, NazwiskoStudenta, AdresStudenta, MiastoStudenta, StanZamStudenta, 
   KodPocztowyStudenta, NumKierStudenta, TelefonStudenta)
SELECT 'Angel' AS ImieStudenta, NazwiskoStudenta, AdresStudenta, MiastoStudenta, StanZamStudenta, 
   KodPocztowyStudenta, NumKierStudenta, TelefonStudenta
FROM Studenci
WHERE (ImieStudenta = 'John') AND (NazwiskoStudenta = 'Kennedy');
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_studenta_zapytanie
AS 
SELECT 'Angel' AS ImieStudenta, NazwiskoStudenta, AdresStudenta, MiastoStudenta, StanZamStudenta, 
   KodPocztowyStudenta, NumKierStudenta, TelefonStudenta
FROM Studenci
WHERE (ImieStudenta = 'John') AND (NazwiskoStudenta = 'Kennedy');


CREATE FUNCTION R16_przyjmij_pracownika_na_studia() RETURNS void AS $$
INSERT INTO Studenci (ImieStudenta, NazwiskoStudenta, AdresStudenta, MiastoStudenta, StanZamStudenta, 
   KodPocztowyStudenta, NumKierStudenta, TelefonStudenta)
SELECT ImiePracownika, NazwiskoPracownika, AdresPracownika, MiastoPracownika, StanZamPracownika, 
   KodPocztowyPracownika, NumKierPracownika, TelefonPracownika
FROM Pracownicy
WHERE (ImiePracownika = 'Tim') AND (NazwiskoPracownika = 'Smith');
$$ LANGUAGE SQL;

CREATE VIEW R16_przyjmij_pracownika_na_studia_zapytanie
AS 
SELECT ImiePracownika, NazwiskoPracownika, AdresPracownika, MiastoPracownika, StanZamPracownika, 
   KodPocztowyPracownika, NumKierPracownika, TelefonPracownika
FROM Pracownicy
WHERE (ImiePracownika = 'Tim') AND (NazwiskoPracownika = 'Smith');


CREATE FUNCTION R17_usun_zajecia_bez_studentow_1() RETURNS void AS $$
DELETE FROM Zajecia_wykladowcow
WHERE (IDZajec NOT IN
                 (SELECT IDZajec
                  FROM Grafik_studenta));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zajecia_bez_studentow_1_zapytanie
AS 
SELECT * 
FROM Zajecia_wykladowcow
WHERE (IDZajec NOT IN
                 (SELECT IDZajec
                  FROM Grafik_studenta));


CREATE FUNCTION R17_usun_zajecia_bez_studentow_2() RETURNS void AS $$
DELETE FROM Zajecia
WHERE (IDZajec NOT IN
                 (SELECT IDZajec
                  FROM Grafik_studenta));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zajecia_bez_studentow_2_zapytanie
AS 
SELECT * 
FROM Zajecia
WHERE (IDZajec NOT IN
                 (SELECT IDZajec
                  FROM Grafik_studenta));


CREATE FUNCTION R17_usun_studentow_nie_uczeszczajacych_na_zajecia() RETURNS void AS $$
DELETE FROM Studenci
WHERE (IDStudenta NOT IN
                 (SELECT IDStudenta
                  FROM Grafik_studenta));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_studentow_nie_uczeszczajacych_na_zajecia_zapytanie
AS 
SELECT *  
FROM Studenci
WHERE (IDStudenta NOT IN
                 (SELECT IDStudenta
                  FROM Grafik_studenta));


CREATE FUNCTION R17_usun_przedmioty_bez_zajec_1() RETURNS void AS $$
DELETE FROM Przedmioty_wykladowcow
WHERE (IDPrzedmiotu NOT IN
                   (SELECT IDPrzedmiotu
                    FROM Zajecia));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_przedmioty_bez_zajec_1_zapytanie
AS 
SELECT * 
FROM Przedmioty_wykladowcow
WHERE (IDPrzedmiotu NOT IN
                   (SELECT IDPrzedmiotu
                    FROM Zajecia));


CREATE FUNCTION R17_usun_przedmioty_bez_zajec_2() RETURNS void AS $$
DELETE FROM Przedmioty
WHERE (IDPrzedmiotu NOT IN
                   (SELECT IDPrzedmiotu
                    FROM Zajecia));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_przedmioty_bez_zajec_2_zapytanie
AS 
SELECT * 
FROM Przedmioty
WHERE (IDPrzedmiotu NOT IN
                   (SELECT IDPrzedmiotu
                    FROM Zajecia));
